using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Results;
using System;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample to show the difference/changes between 2 PDF files.
    /// Expects 2 arguments - the paths of the PDF files
    /// </summary>
    public class NumOfDifferences
    {
        static NumOfDifferences()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show the difference/changes between 2 pdf files.
        /// </summary>
        /// <param name="args">Expected 2 arguments, the path of the PDF files</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            PDFComparer pdfComparer = new PDFComparer();

            using (ResultModel result = pdfComparer.Compare(args[0], args[1]))
            {
                int differences = result.GetDifferencesCount(false);
                System.Console.WriteLine("differences = " + differences);
            }
        }
    }

}